/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HintOfInsanityEffect
extends OneShotEffect {
    HintOfInsanityEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals their hand. That player discards all nonland cards with the same name as another card in their hand";
    }

    private HintOfInsanityEffect(HintOfInsanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public HintOfInsanityEffect copy() {
        return new HintOfInsanityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        HashMap nameCounts = new HashMap();
        player.getHand().getCards(game).stream().map(MageObject::getName).forEach(s -> nameCounts.compute(s, CardUtil::setOrIncrementValue));
        CardsImpl cards = new CardsImpl(player.getHand().getCards(game).stream().filter(Objects::nonNull).filter(card -> !card.isLand(game)).filter(card -> nameCounts.getOrDefault(card.getName(), 0) > 1).collect(Collectors.toSet()));
        player.discard((Cards)cards, false, source, game);
        return true;
    }
}

