/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HiredTorturerEffect
extends OneShotEffect {
    HiredTorturerEffect() {
        super(Outcome.Detriment);
        this.staticText = ", then reveals a card at random from their hand";
    }

    private HiredTorturerEffect(HiredTorturerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && !player.getHand().isEmpty()) {
            CardsImpl revealed = new CardsImpl();
            revealed.add(player.getHand().getRandom(game));
            player.revealCards("Hired Torturer", (Cards)revealed, game);
            return true;
        }
        return false;
    }

    public HiredTorturerEffect copy() {
        return new HiredTorturerEffect(this);
    }
}

