/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class HollowmurkSiegeSultaiTriggeredAbility
extends TriggeredAbilityImpl {
    HollowmurkSiegeSultaiTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.setTriggerPhrase("Whenever a counter is put on a creature you control, ");
        this.setTriggersLimitEachTurn(1);
    }

    private HollowmurkSiegeSultaiTriggeredAbility(HollowmurkSiegeSultaiTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HollowmurkSiegeSultaiTriggeredAbility copy() {
        return new HollowmurkSiegeSultaiTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = Optional.ofNullable(game.getPermanentOrLKIBattlefield(event.getTargetId())).orElse(game.getPermanentEntering(event.getTargetId()));
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }
}

