/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetSpell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HolochessEffect
extends OneShotEffect {
    HolochessEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a number between 0 and 3. If the chosen number is less than the number of creatures an opponent controls, draw X cards where X is the chosen number. Otherwise, counter target spell unless its controller pays {X}.";
    }

    private HolochessEffect(HolochessEffect effect) {
        super((OneShotEffect)effect);
    }

    public HolochessEffect copy() {
        return new HolochessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List creaturesControlledByOpponent;
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (player == null || opponent == null) {
            return false;
        }
        int chosenNumber = player.getAmount(0, 3, "Choose a number between 0 and 3", source, game);
        if (chosenNumber >= (creaturesControlledByOpponent = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, opponent.getId(), game)).size()) {
            if (game.getStack().isEmpty()) {
                return false;
            }
            CounterUnlessPaysEffect counterUnlessPaysEffect = new CounterUnlessPaysEffect((Cost)new GenericManaCost(chosenNumber));
            TargetSpell targetSpell = new TargetSpell();
            player.chooseTarget(Outcome.Benefit, (Target)targetSpell, source, game);
            if (targetSpell.getFirstTarget() == null) {
                return false;
            }
            counterUnlessPaysEffect.setTargetPointer((TargetPointer)new FixedTarget(targetSpell.getFirstTarget()));
            return counterUnlessPaysEffect.apply(game, source);
        }
        player.drawCards(chosenNumber, source, game);
        return true;
    }
}

