/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HolyFrazzleCannonEffect
extends OneShotEffect {
    HolyFrazzleCannonEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on that creature and each other creature you control that shares a creature type with it";
    }

    private HolyFrazzleCannonEffect(HolyFrazzleCannonEffect effect) {
        super((OneShotEffect)effect);
    }

    public HolyFrazzleCannonEffect copy() {
        return new HolyFrazzleCannonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            if (!creature.equals(permanent) && !permanent.shareCreatureTypes(game, (MageObject)creature)) continue;
            creature.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        return true;
    }
}

