/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class HomingSliverEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard("Sliver card");

    public HomingSliverEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each Sliver card in each player's hand has slivercycling {3}";
    }

    private HomingSliverEffect(HomingSliverEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HomingSliverEffect copy() {
        return new HomingSliverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Card card : player.getHand().getCards(filter, game)) {
                    game.getState().addOtherAbility(card, (Ability)new CyclingAbility((Cost)new GenericManaCost(3), filter, "Slivercycling"));
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.SLIVER.getPredicate());
    }
}

