/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.FlippedCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyTokenEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.players.Player;

class HomuraReturnFlippedSourceEffect
extends OneShotEffect {
    private final Token flipToken;

    public HomuraReturnFlippedSourceEffect(Token flipToken) {
        super(Outcome.BecomeCreature);
        this.flipToken = flipToken;
        this.staticText = "return it to the battlefield flipped";
    }

    private HomuraReturnFlippedSourceEffect(HomuraReturnFlippedSourceEffect effect) {
        super((OneShotEffect)effect);
        this.flipToken = effect.flipToken;
    }

    public boolean apply(Game game, Ability source) {
        Card sourceCard = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (sourceCard != null && controller != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD) {
            ConditionalContinuousEffect effect = new ConditionalContinuousEffect((ContinuousEffect)new CopyTokenEffect(this.flipToken), (Condition)FlippedCondition.instance, "");
            game.addEffect((ContinuousEffect)effect, source);
            controller.moveCards(sourceCard, Zone.BATTLEFIELD, source, game);
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent != null) {
                permanent.flip(game);
            }
            return true;
        }
        return false;
    }

    public HomuraReturnFlippedSourceEffect copy() {
        return new HomuraReturnFlippedSourceEffect(this);
    }
}

