/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HordeOfNotionsEffect
extends OneShotEffect {
    HordeOfNotionsEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "You may play target Elemental card from your graveyard without paying its mana cost";
    }

    private HordeOfNotionsEffect(HordeOfNotionsEffect effect) {
        super((OneShotEffect)effect);
    }

    public HordeOfNotionsEffect copy() {
        return new HordeOfNotionsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null && controller.chooseUse(this.outcome, "Play " + card.getName() + " from your graveyard for free?", source, game)) {
                controller.playCard(card, game, true, new ApprovingObject(source, game));
            }
            return true;
        }
        return false;
    }
}

