/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawDiscardControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPlayersEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class HordewingSkaabTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    HordewingSkaabTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, true);
    }

    private HordewingSkaabTriggeredAbility(HordewingSkaabTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PLAYERS;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage() || !game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.hasSubtype(SubType.ZOMBIE, game);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        HashSet opponents = new HashSet();
        this.getFilteredEvents((BatchEvent)((DamagedBatchForPlayersEvent)event), game).stream().map(GameEvent::getTargetId).forEach(opponents::add);
        if (opponents.isEmpty()) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new DrawDiscardControllerEffect(opponents.size(), opponents.size()));
        return true;
    }

    public HordewingSkaabTriggeredAbility copy() {
        return new HordewingSkaabTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more Zombies you control deal combat damage to one or more of your opponents, you may draw cards equal to the number of opponents dealt damage this way. If you do, discard that many cards.";
    }
}

