/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HornOfPlentyEffect
extends OneShotEffect {
    HornOfPlentyEffect() {
        super(Outcome.Detriment);
        this.staticText = "they may pay {1}. If the player does, they draw a card at the beginning of the next end step";
    }

    private HornOfPlentyEffect(HornOfPlentyEffect effect) {
        super((OneShotEffect)effect);
    }

    public HornOfPlentyEffect copy() {
        return new HornOfPlentyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ManaCostsImpl cost;
        Player caster = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (caster != null && caster.chooseUse(Outcome.DrawCard, "Pay {1} to draw a card at the beginning of the next end step?", source, game) && (cost = new ManaCostsImpl("{1}")).pay(source, game, source, caster.getId(), false, null)) {
            DrawCardTargetEffect effect = new DrawCardTargetEffect(1);
            effect.setTargetPointer((TargetPointer)new FixedTarget(caster.getId()));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect, TargetController.ANY), source);
            return true;
        }
        return false;
    }
}

