/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.HornetToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HornetCannonEffect
extends OneShotEffect {
    HornetCannonEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 1/1 colorless Insect artifact creature token with flying and haste named Hornet. Destroy it at the beginning of the next end step.";
    }

    private HornetCannonEffect(HornetCannonEffect effect) {
        super((OneShotEffect)effect);
    }

    public HornetCannonEffect copy() {
        return new HornetCannonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HornetToken hornetToken = new HornetToken();
        hornetToken.putOntoBattlefield(1, game, source, source.getControllerId());
        for (UUID tokenId : hornetToken.getLastAddedTokenIds()) {
            Permanent tokenPermanent = game.getPermanent(tokenId);
            if (tokenPermanent == null) continue;
            DestroyTargetEffect destroyEffect = new DestroyTargetEffect(false);
            destroyEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenPermanent, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)destroyEffect), source);
        }
        return true;
    }
}

