/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class HostageTakerExileEffect
extends OneShotEffect {
    HostageTakerExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile another target creature or artifact until {this} leaves the battlefield. You may cast that card for as long as it remains exiled, and you may spend mana as though it were mana of any type to cast that spell";
    }

    private HostageTakerExileEffect(HostageTakerExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public HostageTakerExileEffect copy() {
        return new HostageTakerExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent card = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || card == null) {
            return false;
        }
        Player controller = game.getPlayer(card.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
        controller.moveCardToExileWithInfo((Card)card, exileId, permanent.getIdName(), source, game, Zone.BATTLEFIELD, true);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)true);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        return true;
    }
}

