/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SuspectTargetEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.abilities.effects.common.continuous.GainControlAllUntapGainHasteEffect;
import mage.abilities.triggers.BeginningOfCombatTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.h.HotPursuitCondition;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.GoadedPredicate;
import mage.filter.predicate.permanent.SuspectedPredicate;
import mage.target.Target;
import mage.target.common.TargetOpponentsCreaturePermanent;
import mage.watchers.Watcher;
import mage.watchers.common.PlayerLostGameWatcher;

public final class HotPursuit
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("goaded and/or suspected creatures");

    public HotPursuit(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");
        EntersBattlefieldTriggeredAbility ability = new EntersBattlefieldTriggeredAbility((Effect)new SuspectTargetEffect());
        ability.addEffect((Effect)new GoadTargetEffect(Duration.UntilSourceLeavesBattlefield).setText("as long as {this} remains on the battlefield, that creature is also goaded"));
        ability.addTarget((Target)new TargetOpponentsCreaturePermanent());
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new BeginningOfCombatTriggeredAbility((Effect)new GainControlAllUntapGainHasteEffect(filter)).withInterveningIf((Condition)HotPursuitCondition.instance), (Watcher)new PlayerLostGameWatcher());
    }

    private HotPursuit(HotPursuit card) {
        super((CardImpl)card);
    }

    public HotPursuit copy() {
        return new HotPursuit(this);
    }

    static {
        filter.add(Predicates.or((Predicate)GoadedPredicate.instance, (Predicate)SuspectedPredicate.instance));
    }
}

