/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.HourOfNeedSphinxToken;
import mage.players.Player;

class HourOfNeedExileEffect
extends OneShotEffect {
    HourOfNeedExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile any number of target creatures. For each creature exiled this way, its controller creates a 4/4 blue Sphinx creature token with flying";
    }

    private HourOfNeedExileEffect(HourOfNeedExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public HourOfNeedExileEffect copy() {
        return new HourOfNeedExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashMap<UUID, Integer> tokenCounts = new HashMap<UUID, Integer>();
        for (UUID creatureId : this.getTargetPointer().getTargets(game, source)) {
            Permanent creature = game.getPermanent(creatureId);
            if (creature == null || !controller.moveCards((Card)creature, Zone.EXILED, source, game)) continue;
            tokenCounts.put(creature.getControllerId(), tokenCounts.getOrDefault(creature.getControllerId(), 0) + 1);
        }
        if (tokenCounts.values().stream().noneMatch(i -> i > 0)) {
            return false;
        }
        game.processAction();
        HourOfNeedSphinxToken token = new HourOfNeedSphinxToken();
        for (Map.Entry playerTokenCount : tokenCounts.entrySet()) {
            token.putOntoBattlefield(((Integer)playerTokenCount.getValue()).intValue(), game, source, (UUID)playerTokenCount.getKey());
        }
        return true;
    }
}

