/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HowlingMineAbility
extends TriggeredAbilityImpl {
    public HowlingMineAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardTargetEffect(1));
    }

    private HowlingMineAbility(HowlingMineAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HowlingMineAbility copy() {
        return new HowlingMineAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        return true;
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent source = game.getPermanentOrLKIBattlefield(this.sourceId);
        return source != null && !source.isTapped();
    }

    public String getRule() {
        return "At the beginning of each player's draw step, if {this} is untapped, that player draws an additional card.";
    }
}

