/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.TreasureToken;
import mage.watchers.common.CardsDrawnDuringDrawStepWatcher;

class HullbreacherReplacementEffect
extends ReplacementEffectImpl {
    HullbreacherReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If an opponent would draw a card except the first one they draw in each of their draw steps, instead you create a Treasure token";
    }

    private HullbreacherReplacementEffect(HullbreacherReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public HullbreacherReplacementEffect copy() {
        return new HullbreacherReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        new TreasureToken().putOntoBattlefield(1, game, source, source.getControllerId());
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        if (!game.isActivePlayer(event.getPlayerId()) || game.getTurnStepType() != PhaseStep.DRAW) {
            return true;
        }
        CardsDrawnDuringDrawStepWatcher watcher = (CardsDrawnDuringDrawStepWatcher)game.getState().getWatcher(CardsDrawnDuringDrawStepWatcher.class);
        return watcher != null && watcher.getAmountCardsDrawn(event.getPlayerId()) > 0;
    }
}

