/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.h.HuntedByTheFamilyFirstChoice;
import mage.cards.h.HuntedByTheFamilySecondChoice;
import mage.choices.FaceVillainousChoice;
import mage.choices.VillainousChoice;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HuntedByTheFamilyEffect
extends OneShotEffect {
    HuntedByTheFamilyEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to four target creatures you don't control. For each of them, that creature's controller faces a villainous choice &mdash; That creature becomes a 1/1 white Human creature and loses all abilities, or you create a token that's a copy of it";
    }

    private HuntedByTheFamilyEffect(HuntedByTheFamilyEffect effect) {
        super((OneShotEffect)effect);
    }

    public HuntedByTheFamilyEffect copy() {
        return new HuntedByTheFamilyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            Player player = game.getPlayer(game.getControllerId(targetId));
            if (permanent == null || player == null) continue;
            FaceVillainousChoice choice = new FaceVillainousChoice(Outcome.DestroyPermanent, (VillainousChoice)new HuntedByTheFamilyFirstChoice(permanent), (VillainousChoice)new HuntedByTheFamilySecondChoice(permanent));
            choice.faceChoice(player, game, source);
        }
        return true;
    }
}

