/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandFromBattlefieldAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;

class HurkylsRecallReturnToHandEffect
extends OneShotEffect {
    HurkylsRecallReturnToHandEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return all artifacts target player owns to their hand";
    }

    private HurkylsRecallReturnToHandEffect(HurkylsRecallReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        if (this.getTargetPointer().getFirst(game, source) != null) {
            FilterArtifactPermanent filter = new FilterArtifactPermanent();
            filter.add((Predicate)new OwnerIdPredicate(this.getTargetPointer().getFirst(game, source)));
            return new ReturnToHandFromBattlefieldAllEffect((FilterPermanent)filter).apply(game, source);
        }
        return false;
    }

    public HurkylsRecallReturnToHandEffect copy() {
        return new HurkylsRecallReturnToHandEffect(this);
    }
}

