/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class HustleBustleEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("face-down creature you control");

    HustleBustleEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may turn a face-down creature you control face up";
    }

    private HustleBustleEffect(HustleBustleEffect effect) {
        super((OneShotEffect)effect);
    }

    public HustleBustleEffect copy() {
        return new HustleBustleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.turnFaceUp(source, game, source.getControllerId());
    }

    static {
        filter.add((Predicate)FaceDownPredicate.instance);
    }
}

