/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.h.HyldasCrownOfWinterAdjuster;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class HyldasCrownOfWinter
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("tapped creature your opponents control");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public HyldasCrownOfWinter(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}");
        this.supertype.add(SuperType.LEGENDARY);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new TapTargetEffect(), (Cost)new GenericManaCost(1));
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetCreaturePermanent());
        ability.addEffect((Effect)new InfoEffect("this ability costs {1} less to activate during your turn"));
        ability.setCostAdjuster((CostAdjuster)HyldasCrownOfWinterAdjuster.instance);
        this.addAbility((Ability)ability);
        ability = new SimpleActivatedAbility((Effect)new DrawCardSourceControllerEffect(xValue), (Cost)new GenericManaCost(3));
        ability.addCost((Cost)new SacrificeSourceCost());
        ability.addHint(hint);
        this.addAbility((Ability)ability);
    }

    private HyldasCrownOfWinter(HyldasCrownOfWinter card) {
        super((CardImpl)card);
    }

    public HyldasCrownOfWinter copy() {
        return new HyldasCrownOfWinter(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        xValue = new PermanentsOnBattlefieldCount((FilterPermanent)filter);
        hint = new ValueHint("Tapped creatures your opponents control", xValue);
    }
}

