/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RunEffect
extends OneShotEffect {
    RunEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Attacking creatures you control get +1/+0 until end of turn for each other attacking creature";
    }

    private RunEffect(RunEffect effect) {
        super((OneShotEffect)effect);
    }

    public RunEffect copy() {
        return new RunEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int attackingCreatures = game.getBattlefield().count((FilterPermanent)new FilterAttackingCreature(), controller.getId(), source, game);
            if (attackingCreatures > 1) {
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterAttackingCreature(), controller.getId(), game)) {
                    BoostTargetEffect effect = new BoostTargetEffect(attackingCreatures - 1, 0, Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

