/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SeekEffect
extends OneShotEffect {
    SeekEffect() {
        super(Outcome.GainLife);
        this.staticText = "Search target opponent's library for a card and exile it. You gain life equal to its mana value. Then that player shuffles";
    }

    private SeekEffect(SeekEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeekEffect copy() {
        return new SeekEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || opponent == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.searchLibrary(target, source, game, opponent.getId());
        Card card = opponent.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.EXILED, source, game);
            player.gainLife(card.getManaValue(), game, source);
        }
        opponent.shuffleLibrary(source, game);
        return true;
    }
}

