/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CountersOnDefendingPlayerCreaturesCount
implements DynamicValue {
    private CounterType counterType;

    public CountersOnDefendingPlayerCreaturesCount(CounterType counterType) {
        this.counterType = counterType;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int count = 0;
        UUID defender = game.getCombat().getDefendingPlayerId(sourceAbility.getSourceId(), game);
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, defender, game)) {
            count += permanent.getCounters(game).getCount(this.counterType);
        }
        return count;
    }

    public CountersOnDefendingPlayerCreaturesCount copy() {
        return new CountersOnDefendingPlayerCreaturesCount(this.counterType);
    }

    public String getMessage() {
        return "the number of " + this.counterType.getName() + " counters on creatures they control";
    }
}

