/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ExcessWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> map = new HashMap<UUID, Set<MageObjectReference>>();

    ExcessWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER || !((DamagedEvent)event).isCombatDamage()) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent == null) {
            return;
        }
        this.map.computeIfAbsent(permanent.getControllerId(), x -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game));
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static int getCount(UUID playerId, Game game) {
        return ((ExcessWatcher)game.getState().getWatcher(ExcessWatcher.class)).map.getOrDefault(playerId, Collections.emptySet()).size();
    }
}

