/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.i.IanMalcolmChaoticianWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class IanMalcolmChaoticianCastEffect
extends AsThoughEffectImpl {
    IanMalcolmChaoticianCastEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.PlayForFree);
        this.staticText = "During each player's turn, that player may cast a spell from among the cards they don't own exiled with {this}";
    }

    private IanMalcolmChaoticianCastEffect(IanMalcolmChaoticianCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public IanMalcolmChaoticianCastEffect copy() {
        return new IanMalcolmChaoticianCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!game.isActivePlayer(affectedControllerId) || IanMalcolmChaoticianWatcher.checkUsed(source, game)) {
            return false;
        }
        Card card = game.getCard(CardUtil.getMainCardId((Game)game, (UUID)sourceId));
        if (card == null || card.isLand(game)) {
            return false;
        }
        MageObjectReference sourceMOR = new MageObjectReference(source.getSourceId(), game);
        return !card.getOwnerId().equals(affectedControllerId) && IanMalcolmChaoticianWatcher.checkExile(sourceMOR, card, game, 0);
    }
}

