/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.cards.i.IanMalcolmChaoticianWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.CardState;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

class IanMalcolmChaoticianManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    IanMalcolmChaoticianManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = ", and mana of any type can be spent to cast it";
    }

    private IanMalcolmChaoticianManaEffect(IanMalcolmChaoticianManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public IanMalcolmChaoticianManaEffect copy() {
        return new IanMalcolmChaoticianManaEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!game.isActivePlayer(affectedControllerId) || IanMalcolmChaoticianWatcher.checkUsed(source, game)) {
            return false;
        }
        MageObjectReference sourceMOR = new MageObjectReference(source.getSourceId(), game);
        Card card = game.getCard(CardUtil.getMainCardId((Game)game, (UUID)sourceId));
        if (card == null) {
            return false;
        }
        if (game.getState().getZone(card.getId()) == Zone.EXILED) {
            return IanMalcolmChaoticianWatcher.checkExile(sourceMOR, card, game, 0);
        }
        CardState cardState = game.getLastKnownInformationCard(card.getMainCard().getId(), Zone.EXILED);
        return cardState != null && IanMalcolmChaoticianWatcher.checkExile(sourceMOR, card, game, 1);
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

