/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObjectReference;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.Card;
import mage.cards.i.IceCauldronConditionalMana;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class IceCauldronAddManaEffect
extends ManaEffect {
    private Mana storedMana;
    private MageObjectReference exiledCardMor;

    IceCauldronAddManaEffect() {
        this.staticText = "Add {this}'s last noted type and amount of mana. Spend this mana only to cast the last card exiled with {this}";
    }

    private IceCauldronAddManaEffect(IceCauldronAddManaEffect effect) {
        super((ManaEffect)effect);
        this.storedMana = effect.storedMana == null ? null : effect.storedMana.copy();
        this.exiledCardMor = effect.exiledCardMor;
    }

    public IceCauldronAddManaEffect copy() {
        return new IceCauldronAddManaEffect(this);
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Permanent iceCauldron = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (iceCauldron != null && controller != null) {
            this.storedMana = (Mana)game.getState().getValue("IceCauldronMana" + source.getSourceId().toString());
            this.exiledCardMor = (MageObjectReference)game.getState().getValue("IceCauldronCard" + source.getSourceId().toString());
            if (this.storedMana != null) {
                Card card = this.exiledCardMor.getCard(game);
                if (card == null && (card = game.getCard(this.exiledCardMor.getSourceId())) != null && (card.getZoneChangeCounter(game) != this.exiledCardMor.getZoneChangeCounter() + 1 || game.getState().getZone(card.getId()) != Zone.STACK)) {
                    card = null;
                }
                if (card != null) {
                    return new IceCauldronConditionalMana(this.storedMana, card);
                }
            }
        }
        return mana;
    }
}

