/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class IcequakeEffect
extends OneShotEffect {
    IcequakeEffect() {
        super(Outcome.Damage);
        this.staticText = "Destroy target land. If that land was a snow land, {this} deals 1 damage to that land's controller.";
    }

    private IcequakeEffect(IcequakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public IcequakeEffect copy() {
        return new IcequakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && (controller = game.getPlayer(permanent.getControllerId())) != null) {
            permanent.destroy(source, game, false);
            if (permanent.isSnow(game)) {
                controller.damage(1, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

