/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class IchneumonDruidWatcher
extends Watcher {
    private final Map<UUID, Integer> playerInstantCount = new HashMap<UUID, Integer>();

    public IchneumonDruidWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            UUID playerId = event.getPlayerId();
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell != null && spell.isInstant(game)) {
                this.playerInstantCount.putIfAbsent(event.getPlayerId(), 0);
                this.playerInstantCount.compute(playerId, (k, v) -> v + 1);
            }
        }
    }

    public boolean moreThanTwoInstantsCast(UUID playerId, Game game) {
        return this.playerInstantCount.get(playerId) > 1;
    }

    public void reset() {
        this.playerInstantCount.clear();
    }
}

