/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileUntilSourceLeavesEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IdrisSoulOfTheTARDISExileEffect
extends OneShotEffect {
    IdrisSoulOfTheTARDISExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile another artifact you control until {this} leaves the battlefield";
    }

    private IdrisSoulOfTheTARDISExileEffect(IdrisSoulOfTheTARDISExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public IdrisSoulOfTheTARDISExileEffect copy() {
        return new IdrisSoulOfTheTARDISExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_ARTIFACT, source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_ARTIFACT);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && new ExileUntilSourceLeavesEffect().setTargetPointer((TargetPointer)new FixedTarget(permanent, game)).apply(game, source);
    }
}

