/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class IgnisScientiaEffect
extends OneShotEffect {
    IgnisScientiaEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card from a graveyard. If a creature card was exiled this way, create a Food token";
    }

    private IgnisScientiaEffect(IgnisScientiaEffect effect) {
        super((OneShotEffect)effect);
    }

    public IgnisScientiaEffect copy() {
        return new IgnisScientiaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        boolean flag = card.isCreature(game);
        player.moveCards(card, Zone.EXILED, source, game);
        if (flag) {
            new TreasureToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

