/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class IgniteMemoriesEffect
extends OneShotEffect {
    IgniteMemoriesEffect() {
        super(Outcome.Damage);
        this.staticText = "Target player reveals a card at random from their hand. {this} deals damage to that player equal to that card's mana value";
    }

    private IgniteMemoriesEffect(IgniteMemoriesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            if (!controller.getHand().isEmpty()) {
                CardsImpl revealed = new CardsImpl();
                Card card = controller.getHand().getRandom(game);
                if (card != null) {
                    revealed.add(card);
                    controller.revealCards(sourceObject.getIdName(), (Cards)revealed, game);
                    controller.damage(card.getManaValue(), source.getSourceId(), source, game);
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public IgniteMemoriesEffect copy() {
        return new IgniteMemoriesEffect(this);
    }
}

