/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.i.IllicitMasqueradePredicate;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FirstTargetPointer;
import mage.target.targetpointer.TargetPointer;

class IllicitMasquerageAbility
extends DiesCreatureTriggeredAbility {
    private static final FilterPermanent filter1 = new FilterCreaturePermanent("a creature you control with an impostor counter on it");
    private static final FilterCard filter2 = new FilterCreatureCard("other target creature card from your graveyard");

    IllicitMasquerageAbility() {
        super((Effect)new ExileTargetEffect().setText("exile it"), false, filter1, true);
        this.addEffect((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        this.addTarget((Target)new TargetCardInYourGraveyard(0, 1, filter2));
    }

    private IllicitMasquerageAbility(IllicitMasquerageAbility ability) {
        super((DiesCreatureTriggeredAbility)ability);
    }

    public IllicitMasquerageAbility copy() {
        return new IllicitMasquerageAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            this.getEffects().stream().filter(ReturnFromGraveyardToBattlefieldTargetEffect.class::isInstance).forEach(effect -> effect.setTargetPointer((TargetPointer)new FirstTargetPointer()));
            return true;
        }
        return false;
    }

    static {
        filter1.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter1.add((Predicate)CounterType.IMPOSTOR.getPredicate());
        filter2.add((ObjectSourcePlayerPredicate)IllicitMasqueradePredicate.instance);
    }
}

