/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class IllusoryGainsEffect
extends OneShotEffect {
    IllusoryGainsEffect() {
        super(Outcome.Detriment);
        this.staticText = "attach {this} to that creature";
    }

    private IllusoryGainsEffect(IllusoryGainsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Permanent opponentCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent illusoryGains = game.getPermanent(source.getSourceId());
        if (you != null && opponentCreature != null && illusoryGains != null) {
            Permanent oldCreature = game.getPermanent(illusoryGains.getAttachedTo());
            if (oldCreature == null) {
                return false;
            }
            if (oldCreature.removeAttachment(illusoryGains.getId(), source, game)) {
                return opponentCreature.addAttachment(illusoryGains.getId(), source, game);
            }
        }
        return false;
    }

    public IllusoryGainsEffect copy() {
        return new IllusoryGainsEffect(this);
    }
}

