/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class ImaginaryThreatsEffect
extends OneShotEffect {
    ImaginaryThreatsEffect() {
        super(Outcome.Detriment);
        this.staticText = "Creatures target opponent controls attack this turn if able";
    }

    private ImaginaryThreatsEffect(ImaginaryThreatsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImaginaryThreatsEffect copy() {
        return new ImaginaryThreatsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(player.getId()));
            AttacksIfAbleAllEffect effect = new AttacksIfAbleAllEffect((FilterPermanent)filter, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

