/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImmovableRodAbilityEffect
extends ContinuousEffectImpl {
    ImmovableRodAbilityEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Detriment);
        this.staticText = "for as long as {this} remains tapped, another target permanent loses all abilities";
    }

    private ImmovableRodAbilityEffect(ImmovableRodAbilityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent == null || !sourcePermanent.isTapped() || permanent == null) {
            this.discard();
            return false;
        }
        permanent.removeAllAbilities(source.getSourceId(), game);
        return true;
    }

    public ImmovableRodAbilityEffect copy() {
        return new ImmovableRodAbilityEffect(this);
    }
}

