/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.DestroySourceEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ImprisonTriggeredAbility
extends TriggeredAbilityImpl {
    ImprisonTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new CounterTargetEffect().setText("counter that ability"), (Effect)new DestroySourceEffect(), (Cost)new ManaCostsImpl("{1}")));
        this.setTriggerPhrase("Whenever a player activates an ability of enchanted creature with {T} in its activation cost that isn't a mana ability, ");
    }

    private ImprisonTriggeredAbility(ImprisonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ImprisonTriggeredAbility copy() {
        return new ImprisonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanentOrLKIBattlefield(this.sourceId);
        if (enchantment != null && enchantment.getAttachedTo() != null) {
            String abilityText;
            StackAbility stackAbility;
            Permanent enchantedPermanent = game.getPermanentOrLKIBattlefield(enchantment.getAttachedTo());
            if (event.getSourceId().equals(enchantedPermanent.getId()) && !(stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId())).getStackAbility().isManaActivatedAbility() && ((abilityText = stackAbility.getRule(true)).contains("{T},") || abilityText.contains("{T}:") || abilityText.contains("{T} or"))) {
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(stackAbility.getId()));
                return true;
            }
        }
        return false;
    }
}

