/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RemoveFromCombatTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.BlockedByOnlyOneCreatureThisCombatWatcher;

class ImprisonUnblockEffect
extends OneShotEffect {
    ImprisonUnblockEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap the creature, remove it from combat, and creatures it was blocking that had become blocked by only that creature this combat become unblocked";
    }

    private ImprisonUnblockEffect(ImprisonUnblockEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImprisonUnblockEffect copy() {
        return new ImprisonUnblockEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && (permanent = game.getPermanent(enchantment.getAttachedTo())) != null && permanent.isCreature(game)) {
            Set combatGroups;
            permanent.tap(source, game);
            RemoveFromCombatTargetEffect effect = new RemoveFromCombatTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
            BlockedByOnlyOneCreatureThisCombatWatcher watcher = (BlockedByOnlyOneCreatureThisCombatWatcher)game.getState().getWatcher(BlockedByOnlyOneCreatureThisCombatWatcher.class);
            if (watcher != null && (combatGroups = watcher.getBlockedOnlyByCreature(permanent.getId())) != null) {
                for (CombatGroup combatGroup : combatGroups) {
                    if (combatGroup == null) continue;
                    combatGroup.setBlocked(false, game);
                }
            }
            return true;
        }
        return false;
    }
}

