/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class InameLifeAspectEffect
extends OneShotEffect {
    InameLifeAspectEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile it. If you do, return any number of target Spirit cards from your graveyard to your hand";
    }

    private InameLifeAspectEffect(InameLifeAspectEffect effect) {
        super((OneShotEffect)effect);
    }

    public InameLifeAspectEffect copy() {
        return new InameLifeAspectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            if (controller.chooseUse(this.outcome, "Exile " + sourceObject.getLogName() + " to return Spirit cards?", source, game)) {
                ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
                effect.setTargetPointer(this.getTargetPointer().copy());
                effect.getTargetPointer().init(game, source);
                new ExileSourceEffect().apply(game, source);
                return effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

