/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class IncendiaryCommandDrawEffect
extends OneShotEffect {
    IncendiaryCommandDrawEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player discards all the cards in their hand, then draws that many cards";
    }

    private IncendiaryCommandDrawEffect(IncendiaryCommandDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public IncendiaryCommandDrawEffect copy() {
        return new IncendiaryCommandDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            HashMap<UUID, Integer> cardsToDraw = new HashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int cardsInHand;
                player = game.getPlayer(playerId);
                if (player == null || (cardsInHand = player.getHand().size()) <= 0) continue;
                player.discard(cardsInHand, false, false, source, game);
                cardsToDraw.put(playerId, cardsInHand);
            }
            for (Map.Entry toDrawByPlayer : cardsToDraw.entrySet()) {
                player = game.getPlayer((UUID)toDrawByPlayer.getKey());
                if (player == null) continue;
                player.drawCards(((Integer)toDrawByPlayer.getValue()).intValue(), source, game);
            }
            return true;
        }
        return false;
    }
}

