/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.DamagedByWatcher;

class IncinerateEffect
extends ContinuousRuleModifyingEffectImpl {
    IncinerateEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment, true, false);
        this.staticText = "A creature dealt damage this way can't be regenerated this turn";
    }

    private IncinerateEffect(IncinerateEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public IncinerateEffect copy() {
        return new IncinerateEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.REGENERATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DamagedByWatcher watcher = (DamagedByWatcher)game.getState().getWatcher(DamagedByWatcher.class, source.getSourceId());
        if (watcher != null) {
            return watcher.wasDamaged(event.getTargetId(), game);
        }
        return false;
    }
}

