/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.RandomUtil;

class IndoraptorThePerfectHybridDamageEffect
extends OneShotEffect {
    IndoraptorThePerfectHybridDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an opponent at random. {this} deals damage equal to its power to that player unless they sacrifice a nontoken creature.";
    }

    private IndoraptorThePerfectHybridDamageEffect(IndoraptorThePerfectHybridDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public IndoraptorThePerfectHybridDamageEffect copy() {
        return new IndoraptorThePerfectHybridDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList opponents = new ArrayList(game.getOpponents(controller.getId()));
        Player opponent = game.getPlayer((UUID)opponents.get(RandomUtil.nextInt((int)opponents.size())));
        if (opponent == null) {
            return false;
        }
        boolean sacrificed = false;
        TargetSacrifice targetCreature = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN);
        if (targetCreature.canChoose(opponent.getId(), source, game) && opponent.chooseUse(Outcome.Sacrifice, "Sacrifice a nontoken creature?", source, game)) {
            opponent.choose(Outcome.Sacrifice, (Target)targetCreature, source, game);
            Permanent permanentToSac = game.getPermanent(targetCreature.getFirstTarget());
            boolean bl = sacrificed = permanentToSac != null && permanentToSac.sacrifice(source, game);
        }
        if (!sacrificed) {
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
            if (sourcePermanent == null) {
                return false;
            }
            return opponent.damage(sourcePermanent.getPower().getValue(), source, game) > 0;
        }
        return sacrificed;
    }
}

