/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class InevitableBetrayalEffect
extends OneShotEffect {
    InevitableBetrayalEffect() {
        super(Outcome.Benefit);
        this.staticText = "search target opponent's library for a creature card and put that card onto the battlefield under your control. Then that player shuffles";
    }

    private InevitableBetrayalEffect(InevitableBetrayalEffect effect) {
        super((OneShotEffect)effect);
    }

    public InevitableBetrayalEffect copy() {
        return new InevitableBetrayalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        controller.searchLibrary(target, source, game, player.getId());
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

