/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class InfectiousCurseCostReductionEffect
extends CostModificationEffectImpl {
    InfectiousCurseCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Spells you cast that target enchanted player cost {1} less to cast";
    }

    private InfectiousCurseCostReductionEffect(InfectiousCurseCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)1);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        if (!source.isControlledBy(abilityToModify.getControllerId())) {
            return false;
        }
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Spell spell = (Spell)game.getStack().getStackObject(abilityToModify.getId());
        Set allTargets = spell != null ? CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game) : CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game);
        return allTargets.stream().anyMatch(target -> Objects.equals(target, enchantment.getAttachedTo()));
    }

    public InfectiousCurseCostReductionEffect copy() {
        return new InfectiousCurseCostReductionEffect(this);
    }
}

