/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class InfernalDarknessReplacementEffect
extends ReplacementEffectImpl {
    InfernalDarknessReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a land is tapped for mana, it produces {B} instead of any other type";
    }

    private InfernalDarknessReplacementEffect(InfernalDarknessReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public InfernalDarknessReplacementEffect copy() {
        return new InfernalDarknessReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        mana.setToMana(Mana.BlackMana((int)mana.count()));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game);
    }
}

