/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InfernalDenizenEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SWAMP);

    InfernalDenizenEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice two Swamps. If you can't, tap {this}, and an opponent may gain control of a creature you control of their choice for as long as {this} remains on the battlefield";
    }

    private InfernalDenizenEffect(InfernalDenizenEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernalDenizenEffect copy() {
        return new InfernalDenizenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SacrificeTargetCost cost = new SacrificeTargetCost(filter);
        if (cost.canPay(source, source, source.getControllerId(), game) && cost.pay(source, game, source, source.getControllerId(), true)) {
            return true;
        }
        Permanent creature = source.getSourcePermanentIfItStillExists(game);
        if (creature == null) {
            return false;
        }
        creature.tap(source, game);
        TargetOpponent targetPlayer = new TargetOpponent(true);
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return true;
        }
        player.choose(this.outcome, (Target)targetPlayer, source, game);
        Player opponent = game.getPlayer(targetPlayer.getFirstTarget());
        if (opponent == null) {
            return true;
        }
        FilterCreaturePermanent filterPermanent = new FilterCreaturePermanent("creature controlled by " + player.getName());
        filterPermanent.add((Predicate)new ControllerIdPredicate(player.getId()));
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)filterPermanent, true);
        opponent.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent != null) {
            game.addEffect(new GainControlTargetEffect(Duration.UntilSourceLeavesBattlefield, true, opponent.getId()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

