/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class InfernalJudgmentEffect
extends OneShotEffect {
    InfernalJudgmentEffect() {
        super(Outcome.GainLife);
        this.staticText = "exile target colorless creature. You gain life equal to its power";
    }

    private InfernalJudgmentEffect(InfernalJudgmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernalJudgmentEffect copy() {
        return new InfernalJudgmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        int creaturePower = permanent.getPower().getValue();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        player.gainLife(creaturePower, game, source);
        return true;
    }
}

