/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.common.TargetSacrifice;

class InfernalOfferingSacrificeEffect
extends OneShotEffect {
    InfernalOfferingSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Choose an opponent. You and that player each sacrifice a creature. Each player who sacrificed a creature this way draws two cards";
    }

    private InfernalOfferingSacrificeEffect(InfernalOfferingSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernalOfferingSacrificeEffect copy() {
        return new InfernalOfferingSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetOpponent target = new TargetOpponent(true);
            target.choose(Outcome.Sacrifice, source.getControllerId(), source.getSourceId(), source, game);
            Player opponent = game.getPlayer(target.getFirstTarget());
            if (opponent != null) {
                HashMap<UUID, UUID> toSacrifice = new HashMap<UUID, UUID>(2);
                for (UUID playerId : game.getState().getPlayersInRange(player.getId(), game)) {
                    if (!playerId.equals(player.getId()) && !playerId.equals(opponent.getId()) || !(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE)).choose(Outcome.Sacrifice, playerId, source.getControllerId(), source, game)) continue;
                    toSacrifice.put(playerId, target.getFirstTarget());
                }
                ArrayList toDraw = new ArrayList(2);
                for (Map.Entry entry : toSacrifice.entrySet()) {
                    Permanent permanent = game.getPermanent((UUID)entry.getValue());
                    if (permanent == null || !permanent.sacrifice(source, game)) continue;
                    toDraw.add(entry.getKey());
                }
                for (UUID playerId : toDraw) {
                    Player playerToDraw = game.getPlayer(playerId);
                    if (playerToDraw == null) continue;
                    playerToDraw.drawCards(2, source, game);
                }
                return true;
            }
        }
        return false;
    }
}

