/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import java.util.stream.Stream;
import mage.MageItem;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class IngeniousArtilleristTriggeredAbility
extends TriggeredAbilityImpl {
    IngeniousArtilleristTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamagePlayersEffect(Outcome.Benefit, (DynamicValue)SavedDamageValue.MANY, TargetController.OPPONENT), false);
    }

    private IngeniousArtilleristTriggeredAbility(IngeniousArtilleristTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent.getToZone() != Zone.BATTLEFIELD || !this.controllerId.equals(event.getPlayerId())) {
            return false;
        }
        int artifacts = Stream.concat(zEvent.getTokens().stream(), zEvent.getCards().stream().map(MageItem::getId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull)).filter(permanent -> permanent.isArtifact(game)).mapToInt(x -> 1).sum();
        if (artifacts > 0) {
            this.getEffects().setValue("damage", (Object)artifacts);
            return true;
        }
        return false;
    }

    public IngeniousArtilleristTriggeredAbility copy() {
        return new IngeniousArtilleristTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more artifacts enter the battlefield under your control, {this} deals that much damage to each opponent.";
    }
}

