/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IngeniousLeoninEffect
extends OneShotEffect {
    IngeniousLeoninEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature is a Cat, it gains first strike until end of turn";
    }

    private IngeniousLeoninEffect(IngeniousLeoninEffect effect) {
        super((OneShotEffect)effect);
    }

    public IngeniousLeoninEffect copy() {
        return new IngeniousLeoninEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null && permanent.hasSubtype(SubType.CAT, game)) {
            game.addEffect(new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            return true;
        }
        return false;
    }
}

